function varargout = Calculate_Temp_rise_GUI(varargin)
% CALCULATE_TEMP_RISE_GUI MATLAB code for Calculate_Temp_rise_GUI.fig
%      CALCULATE_TEMP_RISE_GUI, by itself, creates a new CALCULATE_TEMP_RISE_GUI or raises the existing
%      singleton*.
%
%      H = CALCULATE_TEMP_RISE_GUI returns the handle to a new CALCULATE_TEMP_RISE_GUI or the handle to
%      the existing singleton*.
%
%      CALCULATE_TEMP_RISE_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CALCULATE_TEMP_RISE_GUI.M with the given input arguments.
%
%      CALCULATE_TEMP_RISE_GUI('Property','Value',...) creates a new CALCULATE_TEMP_RISE_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Calculate_Temp_rise_GUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Calculate_Temp_rise_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Calculate_Temp_rise_GUI

% Last Modified by GUIDE v2.5 29-Dec-2017 17:21:10

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Calculate_Temp_rise_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @Calculate_Temp_rise_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Calculate_Temp_rise_GUI is made visible.
function Calculate_Temp_rise_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Calculate_Temp_rise_GUI (see VARARGIN)

% Choose default command line output for Calculate_Temp_rise_GUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Calculate_Temp_rise_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Calculate_Temp_rise_GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in nlayers.
function nlayers_Callback(hObject, eventdata, handles)
% hObject    handle to nlayers (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns nlayers contents as cell array
%        contents{get(hObject,'Value')} returns selected item from nlayers


% --- Executes during object creation, after setting all properties.
function nlayers_CreateFcn(hObject, eventdata, handles)
% hObject    handle to nlayers (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu2


% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu3.
function popupmenu3_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popupmenu3 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu3


% --- Executes during object creation, after setting all properties.
function popupmenu3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in type.
function type_Callback(hObject, eventdata, handles)
% hObject    handle to type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns type contents as cell array
%        contents{get(hObject,'Value')} returns selected item from type


% --- Executes during object creation, after setting all properties.
function type_CreateFcn(hObject, eventdata, handles)
% hObject    handle to type (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in boundary_condition.
function boundary_condition_Callback(hObject, eventdata, handles)
% hObject    handle to boundary_condition (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns boundary_condition contents as cell array
%        contents{get(hObject,'Value')} returns selected item from boundary_condition


% --- Executes during object creation, after setting all properties.
function boundary_condition_CreateFcn(hObject, eventdata, handles)
% hObject    handle to boundary_condition (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function fs_Callback(hObject, eventdata, handles)
% hObject    handle to fs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of fs as text
%        str2double(get(hObject,'String')) returns contents of fs as a double


% --- Executes during object creation, after setting all properties.
function fs_CreateFcn(hObject, eventdata, handles)
% hObject    handle to fs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function t0_Callback(hObject, eventdata, handles)
% hObject    handle to t0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of t0 as text
%        str2double(get(hObject,'String')) returns contents of t0 as a double


% --- Executes during object creation, after setting all properties.
function t0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to t0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function tf_Callback(hObject, eventdata, handles)
% hObject    handle to tf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of tf as text
%        str2double(get(hObject,'String')) returns contents of tf as a double


% --- Executes during object creation, after setting all properties.
function tf_CreateFcn(hObject, eventdata, handles)
% hObject    handle to tf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function n_t_pts_Callback(hObject, eventdata, handles)
% hObject    handle to n_t_pts (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of n_t_pts as text
%        str2double(get(hObject,'String')) returns contents of n_t_pts as a double


% --- Executes during object creation, after setting all properties.
function n_t_pts_CreateFcn(hObject, eventdata, handles)
% hObject    handle to n_t_pts (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Power_Callback(hObject, eventdata, handles)
% hObject    handle to Power (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Power as text
%        str2double(get(hObject,'String')) returns contents of Power as a double


% --- Executes during object creation, after setting all properties.
function Power_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Power (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function f_mod_Callback(hObject, eventdata, handles)
% hObject    handle to f_mod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of f_mod as text
%        str2double(get(hObject,'String')) returns contents of f_mod as a double


% --- Executes during object creation, after setting all properties.
function f_mod_CreateFcn(hObject, eventdata, handles)
% hObject    handle to f_mod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function r0_Callback(hObject, eventdata, handles)
% hObject    handle to r0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r0 as text
%        str2double(get(hObject,'String')) returns contents of r0 as a double


% --- Executes during object creation, after setting all properties.
function r0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function r1_Callback(hObject, eventdata, handles)
% hObject    handle to r1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of r1 as text
%        str2double(get(hObject,'String')) returns contents of r1 as a double


% --- Executes during object creation, after setting all properties.
function r1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to r1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Cv_Callback(hObject, eventdata, handles)
% hObject    handle to Cv (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Cv as text
%        str2double(get(hObject,'String')) returns contents of Cv as a double


% --- Executes during object creation, after setting all properties.
function Cv_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Cv (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function kr_Callback(hObject, eventdata, handles)
% hObject    handle to kr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kr as text
%        str2double(get(hObject,'String')) returns contents of kr as a double


% --- Executes during object creation, after setting all properties.
function kr_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function kz_Callback(hObject, eventdata, handles)
% hObject    handle to kz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kz as text
%        str2double(get(hObject,'String')) returns contents of kz as a double


% --- Executes during object creation, after setting all properties.
function kz_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kz (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function d_Callback(hObject, eventdata, handles)
% hObject    handle to d (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of d as text
%        str2double(get(hObject,'String')) returns contents of d as a double


% --- Executes during object creation, after setting all properties.
function d_CreateFcn(hObject, eventdata, handles)
% hObject    handle to d (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function G_Callback(hObject, eventdata, handles)
% hObject    handle to G (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of G as text
%        str2double(get(hObject,'String')) returns contents of G as a double


% --- Executes during object creation, after setting all properties.
function G_CreateFcn(hObject, eventdata, handles)
% hObject    handle to G (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function n_r_pts_Callback(hObject, eventdata, handles)
% hObject    handle to n_r_pts (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of n_r_pts as text
%        str2double(get(hObject,'String')) returns contents of n_r_pts as a double


% --- Executes during object creation, after setting all properties.
function n_r_pts_CreateFcn(hObject, eventdata, handles)
% hObject    handle to n_r_pts (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function N_r_Callback(hObject, eventdata, handles)
% hObject    handle to N_r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of N_r as text
%        str2double(get(hObject,'String')) returns contents of N_r as a double


% --- Executes during object creation, after setting all properties.
function N_r_CreateFcn(hObject, eventdata, handles)
% hObject    handle to N_r (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in plot_TvsR.
function plot_TvsR_Callback(hObject, eventdata, handles)
% hObject    handle to plot_TvsR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of plot_TvsR

% --- Executes on button press in plot_pa_Trise.
function plot_pa_Trise_Callback(hObject, eventdata, handles)
% hObject    handle to plot_pa_Trise (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of plot_pa_Trise

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%% determine boundary condition
contents = cellstr(get(handles.boundary_condition,'String'));
boundary_condition = contents{get(handles.boundary_condition,'Value')};
if strcmp(boundary_condition,'Bidirectional')
    bidirectional = 1;
elseif strcmp(boundary_condition,'Insulated')
    bidirectional = 0;
else
    error('error with choice of boundary condition')
end
% assignin('base','bidirectional',bidirectional);

%% determine number of layers
nlayers = str2double(get(handles.nlayers,'String'));
% assignin('base','nlayers',nlayers);

%% determine laser type
contents = cellstr(get(handles.type,'String'));
Type = (contents{get(handles.type,'Value')});
% assignin('base','Type',Type);

%% determine laser repetition rate
fs = str2double(get(handles.fs,'String'));
% assignin('base','fs',fs)

%% determine time vector
t0 = str2double(get(handles.t0,'String'));
tf = str2double(get(handles.tf,'String'));
tpts = str2double(get(handles.n_t_pts,'String'));
t = linspace(t0,tf,tpts);
assignin('base','t',t)

%% determine modulation frequency (or frequencies)
f_mod = str2double(get(handles.f_mod,'String'));
% assignin('base','f_mod',f_mod)

%% determine pump radius
w0 = str2double(get(handles.r0,'String'));
% assignin('base','w0',w0)

%% determine probe radius
w1 = str2double(get(handles.r1,'String'));
% assignin('base','w1',w1)

%% determine absorbed power
Power = str2double(get(handles.Power,'String'));
% assignin('base','Power',Power)
alpha = 1; % absorbed fraction of the surface heating = 1 since gui asks for absorbed power

%% Define Radius
N_r = str2double(get(handles.N_r,'String'));
radius = linspace(0,N_r*w0,str2double(get(handles.n_r_pts,'String')));     % radius points of interest in meters
assignin('base','radius',radius)

Cv = str2num(get(handles.Cv,'String')); 
kz = str2num(get(handles.kz,'String')); 
kr = str2num(get(handles.kr,'String')); 
d = str2num(get(handles.d,'String')); 
G = str2num(get(handles.G,'String')); 

T_top = T_rise(nlayers,bidirectional,t,f_mod,fs,kr,kz,G,d,Cv,Type,w0,radius,Power,alpha);
assignin('base','T_top',T_top)
% Take real, imaginary, and magnitude:
T_top_real = real(T_top);
T_top_imag = imag(T_top);
T_top_mag = abs(T_top);

% Numerically calculate probe averaged temperature rise (magnitude)
if length(radius) > 1
    for ll = 1:length(t)
        Surface_T_rise(ll) = 4/w1^2*trapz(radius(:),radius(:).*T_top(:,ll).*exp(-2*radius(:).^2/w1^2));
    end
else
    Surface_T_rise = T_top;
end
assignin('base','Surface_T_rise',Surface_T_rise)

%% Plot Surface Temperatures

cla(handles.axes2,'reset');
cla(handles.axes1,'reset');
plot_radial_temp = get(handles.plot_TvsR,'Value');
if plot_radial_temp
    axes(handles.axes1)
    for ii = 1:length(t)
            clear T_toplot_real T_toplot_imag T_toplot_mag
            T_toplot_real(:) = T_top_real(:,ii);
            T_toplot_imag(:) = T_top_imag(:,ii);
            T_toplot_mag(:) = T_top_mag(:,ii);
            Mat_saved = [radius(:),T_toplot_real(:),T_toplot_imag(:),T_toplot_mag(:)];
            plot(radius*1e6,T_toplot_real)
            hold on
            plot(radius*1e6,T_toplot_imag)
            plot(radius*1e6,T_toplot_mag)
            legend_data1{3*ii-2} = ['Real, time =', num2str(t(ii)*1e9),'ns, freq = ', num2str(f_mod*1e-6), 'MHz'];
            legend_data1{3*ii-1} = ['Imaginary, time =', num2str(t(ii)*1e9),'ns, freq = ', num2str(f_mod*1e-6), 'MHz'];
            legend_data1{3*ii} = ['Magnitude, time =', num2str(t(ii)*1e9),'ns, freq = ', num2str(f_mod*1e-6), 'MHz'];
    end

    legend(legend_data1)
    xlabel('Radius (\mum)')
    ylabel('Surface temperature (K)')
    title('Surface temperature vs. radius')
end

plot_pa_time = get(handles.plot_pa_Trise,'Value');
if plot_pa_time
    % Plot the probe averaged surface temperature vs time
    
    axes(handles.axes2)
    plot(t*1e9,real(Surface_T_rise(:)),'o-')
    hold on
    plot(t*1e9,imag(Surface_T_rise(:)),'o-')
    plot(t*1e9,abs(Surface_T_rise(:)),'o-')
    xlabel('Time (ns)')
    ylabel('Surface temperature (K)')
    title('Probe-averaged surface temperature vs. time')
    legend('Real','Imaginary','Magnitude')
end
